<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/xsl/v2/flattener.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:import href="string.xsl"/>
    <xsl:output encoding="utf-8" method="xml" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/stylesheets">

		<!-- create xsl:stylesheet element -->
		<xsl:element name="xsl:stylesheet">

			<!-- copy attributes and namespaces of the starting stylesheet -->
			<xsl:copy-of select="./namespace::*"/>
			<xsl:copy-of select="./attribute::*"/>

			<!-- copy the content of all included stylesheets and the content of the starting stylesheet -->
			<xsl:apply-templates select="stylesheet" mode="flatten-stylesheets"/>

		</xsl:element>
    </xsl:template>

	<!-- XSLT Stylesheet concatenation -->

	<xsl:template match="stylesheet" mode="flatten-stylesheets">
		<xsl:if test="not(preceding::stylesheet/@absolute-path = ./@absolute-path)">
			<xsl:copy-of select="*"/>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>