<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/media/common.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<!-- WARNING Pour un document XHTML ne pas utiliser de majuscule dans les meta, nom du fichier css, all tags, ... -->
	<!-- WARNING Pour un document XHTML ne pas utiliser de tags vides -> <div>&#160;</div>   &#160; = espace vide -->
	
	<xsl:output method="xml" indent="yes" encoding="utf-8" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" omit-xml-declaration="no" />
	<xsl:param name="public" select="/RESPONSE/NECTIL/public_url"/>
	<xsl:param name="files" select="/RESPONSE/NECTIL/files_url"/>
	<xsl:param name='media' select="/RESPONSE/RESULTS[@name='media']/MEDIA[1]"/>
	
	<!-- HTML Header -->
	<xsl:template name="header">
		<head>
			<meta name="keywords" content="{$media/DESCRIPTIONS/DESCRIPTION/TITLE} {$media/DESCRIPTIONS/DESCRIPTION/HEADER}"/>
			<meta name="generator" content="Nectil"/>
			<meta name="description" content="Nectil website - Powered by Nectil"/>
			<meta name="date" content="{/RESPONSE/URL/today}"/>
			<meta name="content-language" content="{/RESPONSE/NECTIL/language}"/>
			<meta name="language" content="{/RESPONSE/NECTIL/language}"/>
			<meta name="dateofLastModification" content="{$media/INFO/MODIFICATIONDATE}"/>
			<meta name="robots" content="index,follow"/>
			<meta name="googlebot" content="index,follow"/>
			<meta name="content-type" content="text/html"/>
			<title><xsl:value-of select="$media/DESCRIPTIONS/DESCRIPTION/TITLE" /></title>
			<link rel="stylesheet" type="text/css" href="{$public}common.css" />
			<script type="text/javascript" src="{$public}utilities.js">&#160;</script>
		</head>
	</xsl:template>

</xsl:stylesheet>
