<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/xsl/mailing.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="string.xsl"/>
	<xsl:template match="CSS//*">
		<!--usage-->
		<!--xsl:apply-templates select="//CSS/node()"/-->
		<xsl:choose>
			<xsl:when test="name(.)='nectil_url'">
				<xsl:choose>
					<xsl:when test="@pagetocall!='' and @pagetocall!='undefined'">
						<a class="nectil_link" href="{/RESPONSE/NECTIL/public_url}{@pagetocall}?ID={@ID}&amp;viewing_code={/RESPONSE/RESULTS[@name=&quot;contact_info&quot;]/CONTACT/@viewing_code}">
							<xsl:value-of select="."/>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<a class="nectil_link" href="{/RESPONSE/NECTIL/public_url}{@mediatype}.php?ID={@ID}&amp;viewing_code={/RESPONSE/RESULTS[@name=&quot;contact_info&quot;]/CONTACT/@viewing_code}">
							<xsl:value-of select="."/>
						</a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="name(.)='a'">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="/RESPONSE/NECTIL/public_url"/>Action.php?url=<xsl:call-template name="replace-string"><xsl:with-param name="text" select="@href"/><xsl:with-param name="from" select="'&amp;'"/><xsl:with-param name="to" select="'%26'"/></xsl:call-template>&amp;viewing_code=<xsl:value-of select="/RESPONSE/RESULTS[@name='contact_info']/CONTACT/@viewing_code"/></xsl:attribute>
					<xsl:copy-of select="./attribute::*[name()!='href']"/>
					<xsl:apply-templates/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="{local-name()}">
					<xsl:copy-of select="./attribute::*"/>
					<xsl:if test="name(..)='CSS' and not(node())">&#160;</xsl:if><!-- empty paragraph style -->
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
