<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/commandline.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__)."/../common/sushee.class.php");

class commandLine extends SusheeObject{
	
	var $command;
	var $output;
	var $logging = true;
	
	function commandLine($command){
		$this->setCommand($command);
	}
	
	function setCommand($command){
		$this->command = $command;
	}
	
	function getCommand(){
		return $this->command;
	}
	
	function enableLogging($boolean){
		$this->logging = $boolean;
	}
	
	function execute(){
		$OS = getServerOS();
		if ($OS=='windows'){
			$this->output = shell_exec('call '.$this->command.' 2>&1');
		}else{
			$this->output = shell_exec($this->command.' 2>&1');
		}
		if($this->logging)
			$this->log($this->command);
		if($this->logging)
			$this->log($this->output);
		return $this->output;
	}
	
	function getOutput(){
		return $this->output;
	}
}

class backgroundProcess extends commandLine{
	
	var $name;
	var $pid_file;
	var $pid;
	
	function backgroundProcess($name){
		$this->name = $name;
		$pids_folder = getFilesRoot()."/pids/";
		makedir($pids_folder);
		$this->pid_file = $pids_folder.$name.".pid";
		$this->pid = false;
	}
	
	function execute(){
		$bkg_command = 'nohup '.$this->command.' > /dev/null & echo $!';
		$pid = exec($bkg_command);
		debug_log('PID is '.$pid);
		saveInFile($pid,$this->pid_file);
		$this->pid = $pid;
		debug_log($this->command);
	}
	
	function getPid(){
		if($this->pid !== false)
			return $this->pid;
		if(file_exists($this->pid_file) && is_readable($this->pid_file)){
			$former_pid = file_in_string($this->pid_file);
			return $former_pid;
		}else
			return false;
	}
	
	function stop(){
		$former_pid = $this->getPid();
		if($former_pid)
			exec('kill '.$former_pid);
	}
	
	function restart(){
		$this->stop();
		$this->execute();
	}
	
	function isRunning(){
		$former_pid = $this->getPid();
		if($former_pid){
			exec('ps '.$former_pid.' 2>&1',$line_array);
			if(sizeof($line_array)>1){
				return true;
			}else
				return false;
		}else
			return false;
	}
}

class babelerLauncher extends backgroundProcess{
	function babelerLauncher(){
		parent::backgroundProcess('babeler');
		$this->setCommand($GLOBALS["phpExecutable"].' '.dirname(__FILE__).'/../private/babeler_server.php');
	}
}

class JavaCommandLine extends SusheeObject{
	
	var $options;
	var $classpath;
	
	function JavaCommandLine(){
		
	}
	
	function execute(){
		$cmd = new commandLine();
		$java = makeExecutableUsable( Sushee_Instance::getConfigValue('javaExecutable') );
		if( Sushee_Instance::getConfigValue('javaMaxMemory') ){
			$memory = (int) Sushee_Instance::getConfigValue('javaMaxMemory');
		}else{
			$memory = 512; // by default
		}
		
		$java_call = $java.' -Xms128M -Xmx'.$memory.'M -Djava.awt.headless=true';
		$java_call.=' '.implode(' ',$this->options);
		$OS = getServerOS();
		if($OS == 'windows')
			$classpath_sep = ';';
		else
			$classpath_sep = ':';
		$java_call.=' -classpath '.implode($classpath_sep,$this->classpath);
		$java_call.=' '.$this->command;
		$cmd->setCommand($java_call);
		
		return $cmd->execute();
	}
	
	function addJavaOption($option){
		$this->options[]=$option;
	}
	
	function addLibrary($lib){
		$this->classpath[]=$lib;
	}
	
	function setCommand($command){
		$this->command = $command;
	}
}

?>