<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/infoxml.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");


// Composes an XML describing the metadata (<INFO/>) of an element

class NectilElementInfo extends SusheeObject{
	
	var $elementID;
	var $ModuleID;
	var $moduleInfo;
	var $elementValues;
	/* InfoProfile */ var $profile;
	/* Array */ var $security_profile;
	
	function NectilElementInfo($ModuleID,$elementID,$elementValues){
		$this->ModuleID = $ModuleID;
		$this->moduleInfo = moduleInfo($ModuleID);
		
		$this->elementID = $elementID;
		$this->elementValues = $elementValues;
		
		$this->profile = new InfoProfile();
	}
	
	function getXML(){
		if ($this->profile->isInfoTagIncluded()){
			$str='<INFO>';
		}else{
			$str='';
		}
		
		
		$profile_array = $this->profile->getIncludedFields();
		$moduleInfo = $this->moduleInfo;
		$elem = $this->elementValues;
		$fields_array = $this->security_profile;
		
		// --------------------
		// No profile was given
		// --------------------
		if ($profile_array===FALSE || $profile_array===NULL){
			$fields_nbr = count($fields_array);
			for($i=0;$i<$fields_nbr;$i++){
				$n=$fields_array[$i];
				$value=$elem[$n];
				$field = $moduleInfo->getField($n);
				if($field->isDate()){
					$str.=$field->encodeDateForNQL($value,$this->profile);
				}else{
					$str.=$field->encodeForNQL($value);
				}

			}
		}else{
			// --------------------
			// Profile is given
			// --------------------
			$fields_nbr = count($fields_array);
			$profile_nbr = count($profile_array);
			$fields_ok = 0;
			for($i=0;$i<$fields_nbr;$i++){
				$n=$fields_array[$i];
				$value=$elem[$n];
				$n=strtoupper($n);
				// we still have to check the profile asks it
				// by default we consider it is asked (if there is no profile)
				//$asked = TRUE;
				// warning : if <INFO> node is empty (and has a get attribute, otherwise this function would not be called) we consider all fields must be included
				$asked = FALSE;
				if (isset($profile_array[$n])){
					$asked = TRUE;
				}
				if ($asked){
					$field = $moduleInfo->getField($fields_array[$i]);
					if($field->isDate()){
						$str.=$field->encodeDateForNQL($value,$this->profile);
					}else{
						$str.=$field->encodeForNQL($value);
					}
					$fields_ok++;
					if ($fields_ok==$profile_nbr)// we did all the fields
						break;
				}

			 }
		}
		if($this->profile->isCreatorInfoIncluded() || $this->profile->isModifierInfoIncluded() || $this->profile->isOwnerInfoIncluded()){

			$moduleContactInfo = moduleInfo('contact');
			// the set of fields to display when owner-info or creator-info or modifier-info="small"
			if($this->profile->getCreatorInfoProfile()=='small' || $this->profile->getModifierInfoProfile()=='small' || $this->profile->getOwnerInfoProfile()=='small'){
				require_once(dirname(__FILE__)."/../common/fields.class.php");
				$contact_fields_collection = new FieldsCollection();
				$contact_fields_collection->add(new DBField('FirstName'));
				$contact_fields_collection->add(new DBField('LastName'));
				$contact_fields_collection->add(new DBField('Email1'));
				$contact_fields_collection->add(new DBField('Denomination'));
				$contact_fields_collection->add(new DBField('ContactType'));
			}


			if($this->profile->isCreatorInfoIncluded()){
				if($this->profile->getCreatorInfoProfile()==='small'){
					// <CONTACT ID="..." firstname="..."/>
					$ID = $elem['CreatorID'];
					$contact = new Contact($ID);
					$contact->loadFields($contact_fields_collection);

					// constructing the node
					$node_str = new StringXMLNode('CONTACT');
					$node_str->setAttribute('ID',$ID);
					$contact_fields_collection->reset();
					while($field = $contact_fields_collection->next()){
						$fieldname = $field->getName();
						$node_str->setAttribute(strtolower($fieldname),$contact->getField($fieldname));
					}
					$creator_str = '<CREATOR>'.$node_str->getXML().'</CREATOR>';
				}else{
					// <CONTACT><INFO>...</INFO></CONTACT>
					$creator_info = getInfo($moduleContactInfo,$elem['CreatorID']);
					$creator_str = generateXMLOutput($creator_info,$moduleContactInfo,array('profile_name'=>'publication'));
				}


			}
			if($this->profile->isModifierInfoIncluded()){
				if($this->profile->getModifierInfoProfile()=='small'){
					// <CONTACT ID="..." firstname="..."/>
					$ID = $elem['ModifierID'];
					$contact = new Contact($ID);
					$contact->loadFields($contact_fields_collection);

					// constructing the node
					$node_str = new StringXMLNode('CONTACT');
					$node_str->setAttribute('ID',$ID);
					$contact_fields_collection->reset();
					while($field = $contact_fields_collection->next()){
						$fieldname = $field->getName();
						$node_str->setAttribute(strtolower($fieldname),$contact->getField($fieldname));
					}
					$modifier_str = '<MODIFIER>'.$node_str->getXML().'</MODIFIER>';

				}else if($this->profile->isCreatorInfoIncluded() && $elem['CreatorID'] == $elem['ModifierID']){
					// not including the same contact twice
				}else{
					// <CONTACT><INFO>...</INFO></CONTACT>
					$modifier_info = getInfo($moduleContactInfo,$elem['ModifierID']);
					$modifier_str = generateXMLOutput($modifier_info,$moduleContactInfo,array('profile_name'=>'publication'));

				}

			}
			if($this->profile->isOwnerInfoIncluded()){
				if($this->profile->getOwnerInfoProfile()==='small'){
					// <CONTACT ID="..." firstname="..."/>
					$ID = $elem['OwnerID'];
					$contact = new Contact($ID);
					$contact->loadFields($contact_fields_collection);

					// constructing the node
					$node_str = new StringXMLNode('CONTACT');
					$node_str->setAttribute('ID',$ID);
					$contact_fields_collection->reset();
					while($field = $contact_fields_collection->next()){
						$fieldname = $field->getName();
						$node_str->setAttribute(strtolower($fieldname),$contact->getField($fieldname));
					}
					$owner_str = '<OWNER>'.$node_str->getXML().'</OWNER>';

				}else if($this->profile->isCreatorInfoIncluded() && $elem['CreatorID'] == $elem['OwnerID']){
					// not including the same contact twice
				}else if($this->profile->isModifierInfoIncluded() && $elem['ModifierID'] == $elem['OwnerID']){
					// not including the same contact twice
				}else{
					// <CONTACT><INFO>...</INFO></CONTACT>
					$owner_info = getInfo($moduleContactInfo,$elem['OwnerID']);
					$owner_str = generateXMLOutput($owner_info,$moduleContactInfo,array('profile_name'=>'publication'));

				}

			}

			$str.=$creator_str;
			$str.=$modifier_str;
			$str.=$owner_str;
		}

		if ($this->profile->isInfoTagIncluded())
			$str.='</INFO>';
		return $str;
	}
	
	function setProfile(/* string or array or object InfoProfile */ $profile){
		if(is_object($profile))
			$this->profile = $profile;
		else
			$this->profile = new InfoProfile($profile);
	}
	
	function setSecurityProfile($profile){
		$this->security_profile = $profile;
	}
	
}

class InfoProfile extends SusheeObject{
	
	var $profile_array;
	var $info_tag = true;
	
	var $include_timestamp = false;
	var $include_ymd = false;
	var $include_weekdays = false;
	
	var $include_creator_info = false;
	var $include_modifier_info = false;
	var $include_owner_info = false;
	
	function InfoProfile(/* array */ $profile_array=false){
		$this->profile_array = $profile_array;
	}
	// -----------------------
	// Manipulate the profile
	// -----------------------
	function includeInfoTag($boolean=true){
		$this->info_tag = $boolean;
	}
	
	function includeTimestamp($boolean=true){
		$this->include_timestamp = $boolean;
	}
	
	function includeYearMonthDay($boolean=true){
		$this->include_ymd = $boolean;
	}
	
	function includeWeekday($boolean=true){
		$this->include_weekdays = $boolean;
	}
	
	function includeCreatorInfo($profile){
		$this->include_creator_info = $profile;
	}
	
	function includeModifierInfo($profile){
		$this->include_modifier_info = $profile;
	}
	
	function includeOwnerInfo($profile){
		$this->include_owner_info = $profile;
	}
	// -----------------------
	// Consult the profile
	// -----------------------
	function getIncludedFields(){
		return $this->profile_array;
	}
	
	function isTimestampIncluded(){
		return $this->include_timestamp;
	}
	
	function isYearMonthDayIncluded(){
		return $this->include_ymd;
	}
	
	function isWeekdayIncluded(){
		return $this->include_weekdays;
	}
	
	function isCreatorInfoIncluded(){
		return ($this->include_creator_info!=false);
	}
	
	function isModifierInfoIncluded(){
		return ($this->include_modifier_info!=false);
	}
	
	function isOwnerInfoIncluded(){
		return ($this->include_owner_info!=false);
	}
	
	function getCreatorInfoProfile(){
		return $this->include_creator_info;
	}
	
	function getModifierInfoProfile(){
		return $this->include_modifier_info;
	}
	
	function getOwnerInfoProfile(){
		return $this->include_owner_info;
	}
	
	function isInfoTagIncluded(){
		return $this->info_tag;
	}
}

?>