<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/nectil_object.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
class SusheeObject{
	function duplicate(){
		if (version_compare(phpversion(), '5.0') === -1)
			return $this;
		else
			return clone($this);
	}
	
	function className(){
		return strtolower(get_class($this));
	}
	
	function log($msg){
		debug_log($msg);
	}
	
	function logSQL($msg){
		sql_log($msg);
	}
	
	function logError($msg){
		errors_log($msg);
	}
	
	function logFunction($msg){
		//if($_GET['log']=='verbose'){
			$this->log($this->className().'.'.$msg);
		//}
	}
	
	function casttoclass($class)
	{
	  return unserialize(preg_replace('/^O:\d+:"[^"]++"/', 'O:' . strlen($class) . ':"' . $class . '"', serialize($this)));
	}
	
	function getError(){
		return $this->error;
	}
	
	function setError($error){
		$this->error = $error;
	}
	
	function getMsg(){
		return $this->msg;
	}
	
	function setMsg($msg){
		$this->msg = $msg;
	}
	
	function addMsg($msg){
		$this->msg.=$msg;
	}
	
}

class NectilObject extends SusheeObject{
	
}

class sushee_Object extends SusheeObject{}

?>