<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/susheesession.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");

class Sushee_Session extends SusheeObject{
	
	static function getVariable($name){
		if(isset($_SESSION[$GLOBALS["nectil_url"]]['sushee'][$name])){
			return $_SESSION[$GLOBALS["nectil_url"]]['sushee'][$name];
		}
		return false;
	}
	
	static function saveVariable($name,$value){
		session_start();
		$_SESSION[$GLOBALS["nectil_url"]]['sushee'][$name] = $value;
	}
	
	static function clearVariable($name){
		session_start();
		unset($_SESSION[$GLOBALS["nectil_url"]]['sushee'][$name]);
	}
	
	static function clearVariableStartingWith($prefix){
		session_start();
		foreach($_SESSION[$GLOBALS["nectil_url"]]['sushee'] as $name=>$value){
			if(substr($name,0,strlen($prefix))==$prefix){
				unset($_SESSION[$GLOBALS["nectil_url"]]['sushee'][$name]);
			}
		}
	}
	
}

?>