<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/fileUploadFlash.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/file.class.php");
require_once(dirname(__FILE__)."/../common/image.class.php");

class FlashFilesUploadPage extends SusheeObject{
	var $files = array();
	
	function upload(){
		if (isset($_FILES)){
			$targetPath=$_GET["target"];
			if($targetPath){
				$dir = new Folder($targetPath);
				if(!$dir->exists()){
					if($_GET['makedir']==='true'){
						$dir->create();
					}else{
						$this->error('Target directory doesn\'t exist');
					}
				}
			}else{
				$this->error('No target directory indicated');
			}
			$upload = new FilesUploader();
			$upload->setTarget($dir);
			$files = array();
			
			
			foreach($_FILES as $key=>$one_file){
				$upload->addFile($one_file);
			}
			
			$upload->execute();
			$this->files = $upload->getFiles();

		}
	}
	
	function transformImages(){
		if($_GET['scenario']){
			$imagesTrans = new MassImageTransformer();
			$imagesTrans->setImageEffect(new ImageScenario($_GET['scenario']));
			foreach($this->files as $one_file){
				$imagesTrans->addFile($one_file);
			}
			$imagesTrans->execute();
		}
	}
	
	function execute(){
		$this->upload();
		$this->transformImages();
		$this->success();
	}
	
	function success(){
		die('res=1');
	}
	
	function error($msg){
		$this->log($msg);
		die('res=0');
	}
}

$flashUpload = new FlashFilesUploadPage();
$flashUpload->execute();

?>