<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_mkdir.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
// use $target

function file_mkdir($queryname,$action,$target){
	global $directoryRoot;
	$target = transformPath(unhtmlentities($target));
	
	$right =  getPathSecurityRight($target);
	
	if ($right!=="W")
		return generateMsgXML(1,"Not authorized to make a new directory there.",0,'',$queryname);
		//die( xml_msg("1","-1","-1","Not authorized to make a new directory there."));
	
	$sourcename = $target;
	$pathExt = "";
	$nname="put there the only file name (without directories)";
	
	if (hidecheck($sourcename)) {
		if(is_dir($directoryRoot.$pathExt.$sourcename)){
			$str = "Directory already exist.";
			return generateMsgXML(1,$str,0,'',$queryname);
			//die( xml_msg("1","-1","-1",$str));
		}
		$old_umask = umask(0);
		$result = mkdir($directoryRoot.$pathExt.$sourcename, 0777);
		umask($old_umask);
		if($result == 0) {
			$str = "Directory could not be created. Please contact your Nectil Administrator.";
			return generateMsgXML(1,$str,0,'',$queryname);
			//die( xml_msg("1","-1","-1",$str));
		}else{
			return generateMsgXML(0,"Directory:".retransformPath($sourcename)." successfully created!",0,'',$queryname);
			//die (xml_msg("0",$userID,$sessionID,"Directory:".retransformPath($sourcename)." successfully created!"));
		}
	}
	else {
		$str = 'Creating Directory: $dirname is a BLOCKED action.';
		return generateMsgXML(1,$str,0,'',$queryname);
		//die( xml_msg("1","-1","-1",$str));
	}
}
?>