<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_move.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/descriptions.inc.php');

function file_move($queryname,$action,$target,$target2){
	global $directoryRoot;
	$target = transformPath(unhtmlentities($target));
	$target2 = transformPath(unhtmlentities($target2));
	
	$right =  getPathSecurityRight($target);
	if ($right===0)
		return generateMsgXML(1,"Not authorized to copy/move this file.",0,'',$queryname);
	$right =  getPathSecurityRight($target2);
	if ($right!=="W")
		return generateMsgXML(1,"Not authorized to copy/move to this target.",0,'',$queryname);
	
	$sourcename = $target;
	$targetname = $target2;
	$pathExt = "";
	$targetpathExt = "";
	$nname="put there the only file name (without directories)";
	
	// Is New name Okay?
	if (hidecheck($nname)) { $go=1; }
	
	if($go==1) {
			// if the user tries to move a published file, we don't really move it, but copy it instead : it's more transparent than an obscure message about the file being published
			$source_begin = substr($target,0,7);
			$target_begin = substr($target2,0,7);
			if ( ($source_begin=='/media/' && $target_begin!='/media/' && isFileInDescription($target)) || (substr($target,0,6)=='/mail/') ){
				$action='copy';
				$strError = 'not_moved_but_copied';
			}else
				$strError = 0;
			if ($action=='copy') {
				if(!file_exists($directoryRoot.$pathExt.$sourcename))
					return generateMsgXML(1,"File to copy doesn't exist.",0,'',$queryname);
				if(is_dir($directoryRoot.$pathExt.$sourcename)){
					makeDir($directoryRoot.$targetpathExt.$targetname);
					$cm_result = copy_content($directoryRoot.$pathExt.$sourcename,$directoryRoot.$targetpathExt.$targetname,false);
				}else
					$cm_result = copy($directoryRoot.$pathExt.$sourcename, $directoryRoot.$targetpathExt.$targetname);
				if($cm_result)
					return generateMsgXML(0,retransformPath($sourcename)." successfully Copied!",0,'',$queryname);
				else
					return generateMsgXML(1,"Permission denied, contact your Nectil administrator",0,'',$queryname);
			} else { // $action='move'
				require_once(dirname(__FILE__)."/../common/services.inc.php");
				changeUsedFiles($sourcename,$targetname);
				//Move
				if (is_dir($directoryRoot.$pathExt.$sourcename)){
					$cm_result = rename($directoryRoot.$pathExt.$sourcename, $directoryRoot.$targetpathExt.$targetname);
					$is_dir = TRUE;
				}else if(file_exists($directoryRoot.$pathExt.$sourcename))
					$cm_result = copy($directoryRoot.$pathExt.$sourcename, $directoryRoot.$targetpathExt.$targetname);
				else
					return generateMsgXML(1,"File to move doesn't exist.",0,'',$queryname);
				if($cm_result){
					$conclusion = TRUE;
					if (!$is_dir)
						$conclusion = unlink($directoryRoot.$pathExt.$sourcename);
					if($conclusion)
						return generateMsgXML(0,retransformPath($sourcename)." successfully Moved!",0,'',$queryname);
					else
						return generateMsgXML(1,"Permission denied, contact your Nectil administrator",0,'',$queryname);
				}else
					return generateMsgXML(1,"Permission denied, contact your Nectil administrator",0,'',$queryname);
			}
	}
}
?>