<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/countries.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
include_once(dirname(__FILE__)."/../private/metasearch_datatypes.inc.php");
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');


class searchCountries extends RetrieveOperation{
	var $countryID = false;
	var $profile = false;
	var $languageID = false;
	
	function parse(){
		
		$this->languageID = $this->firstNode->getAttribute("languageID");
		$this->profile = $this->firstNode->getAttribute("profile");
		$this->countryID = $this->firstNode->getAttribute("ID");
		
		if(!$this->languageID){
			if (isset($GLOBALS["NectilLanguage"]) && $GLOBALS['restrict_language'])
				$this->languageID = $GLOBALS["NectilLanguage"];
			else
				$this->languageID = "eng";
			
		}
		if(substr($this->languageID,0,3)=='fre'){
			$this->languageID = 'fre';
		}
		
		return true;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		
		$db_conn = db_connect(TRUE); // connection to the commmon database
		
		if ($this->profile=="SmallList")
			$sql = "SELECT * FROM `countries` AS ct WHERE `SmallList`=1";
		else if($this->profile=="Europe")
			$sql = "SELECT * FROM `countries` AS ct WHERE `Europe`=1";
		else if($this->countryID)
			$sql = "SELECT * FROM `countries` AS ct WHERE `ID`='".encodeQuote($this->countryID)."'";
		else
			$sql = "SELECT * FROM `countries` AS ct";
		if($this->languageID=='eng' || $this->languageID=='fre' || $this->languageID=='dut')
			$sql.=' ORDER BY '.sql_removeaccents('ct',$this->languageID).'';
		$this->logSQL($sql);
		$rs = $db_conn->Execute($sql);
		
		$xml.='<RESULTS'.$attributes.'>';
		if ($rs){
			while ($row = $rs->FetchRow() ){
				$xml.="<COUNTRY ID='".$row["ID"]."'  ISO2='".$row['ISOAlpha2']."'>";
				$xml.="<UNIVERSAL>".$row["universal"]."</UNIVERSAL>";
				if($this->languageID=='all'){
					$lgs = array('eng','fre','dut','spa','ita','por','ger');
					foreach($lgs as $lg){
						$xml.='<LABEL languageID="'.$lg.'">'.$row[$lg].'</LABEL>';
					}
				}else{
					$xml.="<LABEL>".$row[$this->languageID]."</LABEL>";
				}
				
				$xml.="</COUNTRY>";
			}
		}else{
			$this->setError("Problem getting the countries : the sql query failed.");
			return false;
		}
		
		$xml.="</RESULTS>";
		$this->xml = $xml;
		return true;
	}
}

?>
