<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/exportModule.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

/*

 Exports a xSushee file containing all the commands to create or update one or multiple modules on a distant sushee installation

<EXPORT>
	<MODULE ID="number/string" data="true">
		[<QUERY>
			<SEARCH>...</SEARCH>
		</QUERY>]
	</MODULE>
	<MODULE ID="number/string" data="true">
		[<QUERY>
			<SEARCH>...</SEARCH>
		</QUERY>]
	</MODULE>
</EXPORT>

*/
class sushee_exportModule extends RetrieveOperation{
	
	function parse(){
		return true;
	}
	
	function getCreateElementInfo($module,$ID){
		$shell = new Sushee_Shell();
		$moduleInfo = moduleInfo($module);
		$fields = $moduleInfo->getFields();
		foreach($fields as $field){
			if(!$field->isSystem())
				$fields_return.='<'.$field->getxSusheeName().'/>';
		}
		$shell->addCommand(
			'<GET>
				<'.$module.' ID="'.$ID.'"/>
				<RETURN>
					<INFO>
						'.$fields_return.'
					</INFO>
				</RETURN>
			</GET>');
		$shell->execute();
		$elementNode = $shell->getElement('/RESPONSE/RESULTS/*[1]');
		if($elementNode)
			return '<CREATE><'.$module.'>'.$elementNode->toString('/*').'</'.$module.'></CREATE>';
	}
	
	function operate(){
		$tmpFile = new TempFile();
		$tmpFile->setExtension('xsu'); // xsushee extension
		$tmpFile->append('<QUERY>');
		
		// list of namespace included in the request (to avoid duplicate)
		$namespaces_included = array();
		
		$moduleNodes = $this->operationNode->getElements('/MODULE');
		foreach($moduleNodes as $moduleNode){
			$moduleID = $moduleNode->getAttribute('ID');
			// create the namespace
			$moduleInfo = moduleInfo($moduleID);
			$namespace = $moduleInfo->getNameSpace();
			if($namespace && !$namespaces_included[$namespace->getID()]){
				$namespaces_included[$namespace->getID()] = true;
				$tmpFile->append($this->getCreateElementInfo('NAMESPACE',$namespace->getID()));
			}
			
			// creating the modules
			// <CREATE><MODULE>....
			$tmpFile->append($this->getCreateElementInfo('MODULE',$moduleID));
			
			
			// creating all the fields (even if already existing)
			// <CREATE><FIELD>.... 
			$fields = $moduleInfo->getFields();
			foreach($fields as $field){
				if(!$field->isSystem()){
					$field->register();
					$tmpFile->append($this->getCreateElementInfo('FIELD',$field->getRegistrationID()));
				}
			}

			// updating fields with eventual description
			// <UPDATE><FIELD> ....


			// create a UNIQUE field OriginalID, that will allow to sync existing element with the original database
			// <CREATE><FIELD><INFO><DENOMINATION>OriginalID...
			
			
			// create the processors
			
			// create the lists

			// create the deptype between the modules exported and with the sushee native module
			// <CREATE><DEPENDENCYENTITY> ... 


			// create the first minimal instances of the elements. Because OriginalID is unique, it will not create duplicates
			// <CREATE><element><INFO><ORIGINALID>...


			// updating the elements and linking them together : distant sushee must accept originalID as linking point
			// <UPDATE><element><INFO>...<DEPENDENCIES><DEPENDENCY type=""><element originalID=""/>....
		}
		
		
		$tmpFile->append('</QUERY>');
		
		$this->setXML($tmpFile->toString());
		
		return true;
	}
	
}



?>