<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/processor_processing.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/

class sushee_PROCESSOR_processor{
	
	function postprocess($data){
		// cleaning the session
		$cmd = $data->getValue('COMMAND');
		$type = $data->getValue('TYPE');
		$moduleInfo = moduleInfo($data->getValue('MODULEID'));
		$varName = 'dbproc'.$moduleInfo->getName().$cmd[0].substr($type,0,3);
		Sushee_Session::clearVariable($varName);
	}
	
}

class sushee_CREATE_PROCESSOR_processor extends sushee_PROCESSOR_processor{
	
	function preprocess($data){
		// allowing to set a MODULE, not knowing the real MODULEID
		$moduleName = $data->getElementNode()->valueOf('INFO/MODULE');
		if($moduleName){
			$moduleInfo = moduleInfo($moduleName);
			if($moduleInfo->getID()){
				$data->setValue('MODULEID',$moduleInfo->getID());
			}
		}
		
		// checking there is a module
		if(!$data->getValue('MODULEID')){
			return new SusheeProcessorException('The MODULEID field must be defined for a processor to work');
		}
		// checking there is a type and its valid
		$type = $data->getValue('TYPE');
		if($type!='preprocessor' && $type!='postprocessor'){
			return new SusheeProcessorException('The TYPE field must be `preprocessor` or `postprocessor` or `searchtext`');
		}
		
		return true;
	}
	
}

class sushee_UPDATE_PROCESSOR_processor extends sushee_PROCESSOR_processor{
	
	function preprocess($data){
		return true;
	}
}

class sushee_KILL_PROCESSOR_processor extends sushee_PROCESSOR_processor{
	
	function preprocess($data){
		return true;
	}
	
}

class sushee_DELETE_PROCESSOR_processor extends sushee_PROCESSOR_processor{
	
	function preprocess($data){
		return true;
	}
	
}

class sushee_SEARCH_PROCESSOR_processor{
	
	function preprocess($data){
		// allowing to search with the module name and not only with the moduleID
		$moduleName = $data->getElementNode()->valueOf('INFO/MODULE');
		if($moduleName){
			$moduleInfo = moduleInfo($moduleName);
			if($moduleInfo->getID()){
				$data->getElementNode()->getElement('INFO')->appendChild('<MODULEID>'.$moduleInfo->getID().'</MODULEID>');
			}
		}
		return true;
	}
	
}

?>