<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/rebuild_cache.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
include_once(dirname(__FILE__)."/../common/Cache/Lite.php");

class sushee_CacheFilesCleaner extends SusheeObject{
	
	var $ct = 0;
	
	function execute(){
		$this->logFunction('CacheFilesCleaner.execute');
		session_write_close();
		set_time_limit(0);
		$folders = array();
		$folders[]= new Folder('/cache/xsushee/');
		
		foreach($folders as $folder){
			while($file = $folder->getNextFile()){
				if($file->isWritable()){
					$file->delete();
					$this->ct++;
				}
			}
		}
	}
	
	function countDeletedFiles(){
		return $this->ct;
	}
}

$cleaner = new sushee_CacheFilesCleaner();
$cleaner->execute();

echo $cleaner->countDeletedFiles()." cleaned<br/>";
echo getTimer();
?>
