<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchModule.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/datas_structure.class.php');
require_once(dirname(__FILE__).'/../private/search.inc.php');


class searchModule extends RetrieveOperation{
	
	function parse(){
		
		return true;
	}
	
	function operate(){
		// first, attaching the fields in dependency of the module(s) and only after that we can start the real search in database
		if($this->firstNode->valueOf('INFO/DENOMINATION') || $this->firstNode->valueOf('@denomination') || $this->firstNode->valueOf('DENOMINATION')){
			// denomination of the module is given
			$moduleName = $this->firstNode->valueOf('INFO/DENOMINATION');
			if(!$moduleName){
				$moduleName = $this->firstNode->valueOf('@denomination');
				if(!$moduleName){
					$moduleName = $this->firstNode->valueOf('DENOMINATION'); // former notation (ensuring backward compatibility)
				}
			}
			$moduleInfo = moduleInfo($moduleName);
			if($moduleInfo->loaded){
				// for the SearchElement class to understand what it must return
				$this->firstNode->setAttribute('ID',$moduleInfo->getID());
			}
		}

		$search = new SearchElement($this->getName(),$this->operationNode);
		$res = $search->execute();
		if($res===true){
			$this->setXML($search->getXML());
			return true;
		}else if(is_bool($res)){
			$this->setMsg($search->getMsg());
			return false;
		}else{
			$this->setMsg($res);
			return false;
		}
	}
	
}

?>