<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchWebservice.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/url.class.php');
require_once(dirname(__FILE__).'/../common/webaccount/webaccount.class.php');

class searchWebservice extends RetrieveOperation{
	var $url = false;
	var $method = false;
	var $params = array();
	function parse(){
		$url = decode_from_xml($this->firstNode->valueOf('@url'));
		$url = str_replace(' ','+',$url);
		if(!$url){
			$this->setError('You provided no url for the webservice');
			return false;
		}
		$this->url = $url;
		$this->method = decode_from_xml($this->firstNode->valueOf('@method'));
		
		//$this->log($url);
		return true;
	}
	
	function operate(){
		$webaccountID = $this->firstNode->valueOf('WEBACCOUNT/@ID');
		if($webaccountID){
			$urlHandler = new Sushee_WebAccountRequest(new Sushee_WebAccount($webaccountID),$this->url);
		}else{
			$urlHandler = new URL($this->url);
		}
		
		
		if($this->method)
			$urlHandler->setMethod($this->method);
		$paramsNodes = $this->firstNode->getElements('PARAMS/PARAM');
		$encoding = $this->firstNode->valueOf('PARAMS/@encoding');
		if(!$encoding){
			$encoding = 'utf-8';
		}
		$encoding = strtolower($encoding);
		foreach($paramsNodes as $node){
			if($node->valueOf('@name')){
				if($node->getElements('./*')){
					$urlHandler->addParam(decode_from_xml($node->valueOf('@name')),'<?xml version="1.0"?>'.$node->copyOf('./*[1]'));
				}else{
					$param_name = decode_from_xml($node->valueOf('@name'));
					if($encoding=='utf-8')
						$urlHandler->addParam($param_name,entities_to_utf8(decode_from_xml($node->valueOf())));
					else
						$urlHandler->addParam($param_name,utf8_decode(entities_to_utf8(decode_from_xml($node->valueOf()))));
				}
			}
				
		}
		$urlOutput = $urlHandler->execute();
		if($urlOutput===false){
			$this->setError('The service isn\'t responding');
			return false;
		}
		$webservice_xml = new XML($urlOutput);
		
		$isXML = true;
		if(!$webservice_xml->loaded){
			/*$this->setError('The service didn\'t provide a parseable xml');
			return false;*/
			$isXML = false;
		}else{
			/*unset($urlOutput);
			$urlOutput = null;*/
		}
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		$xml.='<WEBSERVICE url="'.encode_to_xml($this->url).'">';
		if($isXML){
			//$xml_str = $webservice_xml->toString('/','');
			$root = $webservice_xml->nodeName('/*[1]');
			$start_root = strpos($urlOutput,'<'.$root);
			if($root && $start_root!==false){
				$xmlHeader = substr($urlOutput,0,$start_root);
				$xml_str = substr($urlOutput,$start_root);
			}else{
				$xml_str = $urlOutput;
			}
			unset($urlOutput);
			$urlOutput = null;
			//$superRoot = $webservice_xml->nodeIndex[''];
			//$xmlHeader = $webservice_xml->parseSkipWhiteCache ? trim($superRoot['textParts'][0]) : $superRoot['textParts'][0];
			//$this->log('xmlHeader is '.$xmlHeader);
			$matches = array();
			$encoding_present = preg_match('/encoding="([^\"]+)"/',$xmlHeader,$matches);
			if($encoding_present){
				$encoding = strtolower($matches[1]);
				$this->log('encoding is '.$encoding);
				if($encoding =='iso-8859-1'){
					$xml_str = utf8_decode(iso_To_UnicodeEntities($xml_str));
				}else{
					$xml_str = utf8_decode(utf8_To_UnicodeEntities($xml_str));
				}
			}else{
				$xml_str = utf8_decode(utf8_To_UnicodeEntities($xml_str));
			}
			$xml_str = str_replace("\n",'',$xml_str);
		}else{
			$xml_str = encode_to_xml($urlOutput);
		}
		
		
		$xml.=$xml_str;
		$xml.='</WEBSERVICE>';
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
	
}

?>
