<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/updateModule.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/nql.class.php');
require_once(dirname(__FILE__).'/../common/namespace.class.php');
require_once(dirname(__FILE__).'/../common/db_manip.class.php');
require_once(dirname(__FILE__).'/../private/update.nql.php');

class updateModule extends NQLOperation{
	
	var $denomination=false;
	var $ID=false;
	
	function parse(){
		$ID = $this->firstNode->valueOf('@ID');
		if(!$ID){
			$this->setError('No name/ID was provided for the module to update');
			return false;
		}
		$this->ID = $ID;
		return true;
	}
	
	function operate(){
		$this->logFunction('operate');
		$moduleInfo = moduleInfo($this->ID);
		
		
		if(!$moduleInfo->loaded){
			$this->setError('Module with ID:"'.$this->ID.'" doesn\'t exist');
			return false;
		}
		$tableName = $this->firstNode->valueOf('INFO/TABLENAME');
		if($tableName){
			$table = $moduleInfo->getTable();
			if($table){
				$res = $table->changeName($tableName);
				if(!$res){
					$this->setError($table->getError());
					return false;
				}
			}else{
				$this->setError('Table of the module couldnot be found');
				return false;
			}
		}
		// managing advanced security (multigroup and multiowners on objects)
		$isAdvancedSecurityEnabled = $moduleInfo->isAdvancedSecurityEnabled();
		$advancedSecurity = $this->firstNode->valueOf('INFO/ADVANCEDSECURITY');
		if($advancedSecurity!==false){
			
			$table = $moduleInfo->getTable();
			
			if($table){
				if($advancedSecurity==0 && $isAdvancedSecurityEnabled){
					// removing advanced security
					$table->enableAdvancedSecurity(false);
					// for user in session, we disable the security immediately
					$moduleInfo->enableAdvancedSecurity(false);
					
				}else if($advancedSecurity==1 && !$isAdvancedSecurityEnabled){
					// enabling advanced security
					$table->enableAdvancedSecurity(true);
					// for user in session, we enable the security immediately
					$moduleInfo->enableAdvancedSecurity(true);
				}
			}
			
		}

		// we need to register the fields before returning the module infos, because fields are automatically created when found on the database
		$moduleInfo->registerFields();
		// processors were formerly a basic table and not attached to the module with a dependency, registerProcessors creates the dependency with the module
		$moduleInfo->registerProcessors();
		
		// letting the usual update in NQL do its job
		$update = new UpdateElement($this->getName(),$this->operationNode);
		$update->execute();
		$this->setMsg($update->getMsg());
		
		// forcing the session to reload the definition of the module to be synchronised with the changes made
		$moduleInfo->clearInSession();
		
		return true;
	}
	
}

?>